; Diagnostic ROM part 2
; Test 2  Display
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
TEMP	= 	  $F8
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A

; Test 2  Display
;  Switch setting:
;   S6 on
;   --
;   S0 on
;   S1 off
;   S2 on
;   S3 on
; This test the displays. It will also flash the green LED just in case
; the display isn't working so that you know that the test is running.
; It sequences 0000 00 to FFFF FF. Not much else to say here.
;

	.ORG $0C00

TABLE     .BYTE $BF, $86, $DB, $CF, $E6, $ED, $FD, $87, $FF, $EF, $F7, $FC, $B9, $DE, $F9
          .BYTE $F1   
		  
RESET
		  LDX	#$FF		; clear stack and decimal mode
          TXS
          CLD
;		  
          LDX #$FF			;  irst digit and hold tty out with pa0
          STX PADD			; init RRIOT
          LDX #$00
          STX SAD
          LDX #$3F
          STX PBDD
          LDX #$01
          STX SBD
;		  
          CLD
          LDA #$00
          STA TEMP
LLOPP     LDA TEMP
          STA $1000			; flash status LED
;
          LDA #$3F
          STA INH
LOP2     LDX #$13			; loop via software delays
          LDY #$06
LTEMP     LDA TEMP
          AND #$0F
          STY CNT
          TAY
          LDA TABLE,Y		; TABLE
          LDY #$00
          STY SAD			; off display
          STX SBD			; digit
          STA SAD			; seg on
          LDY #$FF			; delay
LX        DEY
          BNE LX
          DEX				; add 2 to advance digit
          DEX
          LDY CNT
          DEY
          BNE LTEMP
          DEC INH
          BNE LOP2
          INC TEMP			; next digit
          JMP LLOPP




HEREV
		.FILL (VECTOR - HEREV)&$FFF, 0

;
; Reset vectors
;	
		  .ORG $FFFA
VECTOR		  

          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
		 .END